package com.androidbook.simpleopengl;

import android.content.Intent;

public class SimpleOpenGLActivity extends MenuActivity {


   @Override
    void prepareMenu() {
        addMenuItem("1a. Trójkąt (czerwony)", BasicGLActivity.class);
        
        Intent colorful = new Intent(this, BasicGLActivity.class);
        colorful.putExtra(BasicGLActivity.COLOR_OPTION_EXTRA, true);
        addMenuItem("1b. Trójkąt (wielokolorowy)", colorful);
        
        Intent wireframe = new Intent(this, ShowGLCubeActivity.class);
        wireframe.putExtra(ShowGLCubeActivity.WIREFRAME_OPTION_EXTRA, true);        
        addMenuItem("2a. Sześcian (krawędzie)", wireframe);
        
        addMenuItem("2b. Sześcian (wypełniony)", ShowGLCubeActivity.class);
        
        addMenuItem("3. Przykład oświetlenia (sześcian)", ShowGLLightingActivity.class);
        addMenuItem("4. Pomiar FPS", ShowGLFramesPerSecActivity.class);
        
        
        addMenuItem("5a. Prezentacja tekstur", ShowGLTextureActivity.class);
        
        Intent coloredCube = new Intent(this, ShowGLTextureActivity.class);
        coloredCube.putExtra(ShowGLTextureActivity.USE_COLOR_CUBE_EXTRA, true);
        addMenuItem("5b. Tekstura z kolorem", coloredCube);
        
        addMenuItem("6. Logo Androida", ShowAndroidGLActivity.class);
    }
}